/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.viewer.statistics;

import filenet.sim.toolkit.viewer.VWSIMAnimatorDataModel;
import filenet.sim.toolkit.viewer.animation.IVWSIMAnimationUpdateListener;
import filenet.sim.toolkit.viewer.animation.VWSIMAnimationController;
import filenet.sim.toolkit.viewer.animation.VWSIMAnimationUpdateEvent;
import filenet.sim.toolkit.viewer.statistics.IVWSIMStatPanel;
import filenet.sim.toolkit.viewer.statistics.VWSIMQueueStatPanel;
import filenet.sim.toolkit.viewer.statistics.VWSIMSimulationStatPanel;
import filenet.sim.toolkit.viewer.statistics.VWSIMStepStatPanel;
import filenet.sim.toolkit.viewer.statistics.VWSIMUserStatPanel;
import filenet.sim.toolkit.viewer.statistics.VWSIMWorkflowStatPanel;
import filenet.sim.toolkit.viewer.statistics.resources.VWSIMResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ItemListener;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VWSIMStatisticsPanel
extends JPanel
implements ChangeListener,
IVWSIMAnimationUpdateListener {
    protected Frame m_parentFrame = null;
    private VWSIMAnimationController m_animationController = null;
    private VWSIMAnimatorDataModel m_dataModel = null;
    private JTabbedPane m_tabbedPane = null;
    private VWSIMSimulationStatPanel m_simulationStatTab = null;
    private VWSIMWorkflowStatPanel m_workflowStatTab = null;
    private VWSIMStepStatPanel m_stepStatTab = null;
    private VWSIMQueueStatPanel m_queueStatTab = null;
    private VWSIMUserStatPanel m_userStatTab = null;
    private IVWSIMStatPanel m_selectedTab = null;
    private boolean m_bNeedUpdate = false;
    private Object m_updateObject = new Object();
    private boolean m_bDone = false;

    public VWSIMStatisticsPanel(Frame parentFrame, VWSIMAnimationController animationController, VWSIMAnimatorDataModel dataModel) {
        this.m_parentFrame = parentFrame;
        this.m_animationController = animationController;
        this.m_dataModel = dataModel;
        this.setLayout(new BorderLayout(0, 0));
        this.m_tabbedPane = new JTabbedPane(3){

            public void addNotify() {
                super.addNotify();
                Font boldFont = null;
                Font font = null;
                font = this.getFont();
                if (font != null && (boldFont = new Font(font.getName(), 1, font.getSize())) != null) {
                    this.setFont(boldFont);
                }
            }
        };
    }

    public void initialize() {
        this.m_tabbedPane.setTabPlacement(3);
        this.m_simulationStatTab = new VWSIMSimulationStatPanel(this.m_parentFrame, this, this.m_dataModel, this.m_animationController);
        this.m_workflowStatTab = new VWSIMWorkflowStatPanel(this.m_parentFrame, this, this.m_dataModel);
        this.m_stepStatTab = new VWSIMStepStatPanel(this.m_parentFrame, this, this.m_dataModel);
        this.m_queueStatTab = new VWSIMQueueStatPanel(this.m_parentFrame, this, this.m_dataModel);
        this.m_userStatTab = new VWSIMUserStatPanel(this.m_parentFrame, this, this.m_dataModel);
        this.m_simulationStatTab.initialize();
        this.m_workflowStatTab.initialize();
        this.m_stepStatTab.initialize();
        this.m_queueStatTab.initialize();
        this.m_userStatTab.initialize();
        this.m_tabbedPane.add((Component)this.m_simulationStatTab, VWSIMResource.s_simulation_statistics_tab);
        this.m_tabbedPane.add((Component)this.m_workflowStatTab, VWSIMResource.s_workflow_statistics_tab);
        this.m_tabbedPane.add((Component)this.m_stepStatTab, VWSIMResource.s_step_statistics_tab);
        this.m_tabbedPane.add((Component)this.m_queueStatTab, VWSIMResource.s_queue_statistics_tab);
        this.m_tabbedPane.add((Component)this.m_userStatTab, VWSIMResource.s_user_statistics_tab);
        this.m_tabbedPane.addChangeListener(this.m_simulationStatTab);
        this.m_tabbedPane.addChangeListener(this.m_workflowStatTab);
        this.m_tabbedPane.addChangeListener(this.m_stepStatTab);
        this.m_tabbedPane.addChangeListener(this.m_queueStatTab);
        this.m_tabbedPane.addChangeListener(this.m_userStatTab);
        this.add((Component)this.m_tabbedPane, "Center");
        this.m_tabbedPane.addChangeListener(this);
        Component comp = this.m_tabbedPane.getSelectedComponent();
        this.m_selectedTab = comp != null && comp instanceof IVWSIMStatPanel ? (IVWSIMStatPanel)((Object)comp) : null;
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
            Component comp = tabbedPane.getSelectedComponent();
            this.m_selectedTab = comp != null && comp instanceof IVWSIMStatPanel ? (IVWSIMStatPanel)((Object)comp) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void animationUpdate(VWSIMAnimationUpdateEvent e) {
        if (e == null || e.getSIMEvent() == null || e.isError()) {
            return;
        }
        Object object = this.m_updateObject;
        synchronized (object) {
            this.m_bNeedUpdate = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateInfo() {
        boolean bUpdate = false;
        while (!this.m_bDone) {
            Object object = this.m_updateObject;
            synchronized (object) {
                bUpdate = false;
                if (this.m_bNeedUpdate) {
                    this.m_bNeedUpdate = false;
                    bUpdate = true;
                }
            }
            if (bUpdate && this.m_selectedTab != null) {
                this.m_selectedTab.updateInfo();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void addItemListener(ItemListener l) {
        this.m_stepStatTab.addItemListener(l);
        this.m_workflowStatTab.addItemListener(l);
    }

    public void removeItemListener(ItemListener l) {
        this.m_stepStatTab.removeItemListener(l);
        this.m_workflowStatTab.removeItemListener(l);
    }

    public void done() {
        this.m_bDone = true;
    }

    public void releaseResources() {
        this.m_parentFrame = null;
        this.m_animationController = null;
        this.m_dataModel = null;
        if (this.m_tabbedPane != null) {
            this.m_tabbedPane.removeChangeListener(this);
            this.m_tabbedPane.removeAll();
            this.m_tabbedPane = null;
        }
        if (this.m_simulationStatTab != null) {
            this.m_simulationStatTab.releaseResources();
            this.m_simulationStatTab = null;
        }
        if (this.m_workflowStatTab != null) {
            this.m_workflowStatTab.releaseResources();
            this.m_workflowStatTab = null;
        }
        if (this.m_stepStatTab != null) {
            this.m_stepStatTab.releaseResources();
            this.m_stepStatTab = null;
        }
        if (this.m_queueStatTab != null) {
            this.m_queueStatTab.releaseResources();
            this.m_queueStatTab = null;
        }
        if (this.m_userStatTab != null) {
            this.m_userStatTab.releaseResources();
            this.m_userStatTab = null;
        }
        this.m_updateObject = null;
        this.removeAll();
    }
}

